<?php $__env->startSection('content'); ?>

<div class="row">
    <div class="col-12">
        <div class="custome-breadcrumb">
        <?php echo e(Breadcrumbs::render('restaurants')); ?>

        </div>
    </div>

    <div class="col-12">
        <div class="db-card">
            <div class="db-card-header border-none">
                <h3 class="db-card-title"><?php echo e(__('restaurant.restaurant_details')); ?></h3>
                <div class="db-card-filter">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('restaurants_create')): ?>
                    <?php if(auth()->user()->myrole == 1): ?>
                    <a href="<?php echo e(route('admin.import-restaurant')); ?>" class="db-card-filter-btn pseudo-none">
                        <i class="fa-solid fa-file-import"></i>
                        <span><?php echo e(__('restaurant.import_restaurant')); ?></span>
                    </a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('admin.restaurants.create')); ?>" class="db-btn h-[38px] text-white bg-primary">
                        <i class="fa-solid fa-circle-plus"></i>
                        <span><?php echo e(__('restaurant.add_restaurant')); ?></span>
                    </a>
                    <?php endif; ?>
                </div>
            </div>


            <div class="db-table-responsive">
                <table class="db-table table stripe" id="maintable" data-url="<?php echo e(route('admin.restaurant.get-restaurant')); ?>" data-status="<?php echo e(\App\Enums\RestaurantStatus::ACTIVE); ?>" data-hidecolumn="<?php echo e(auth()->user()->can('restaurants_show') ||auth()->user()->can('restaurants_edit') ||auth()->user()->can('restaurants_delete')); ?>">
                    <thead class="db-table-head">
                        <tr class="db-table-head-tr">
                            <th class="db-table-head-th"><?php echo e(__('levels.name')); ?></th>
                            <th class="db-table-head-th"><?php echo e(__('levels.user')); ?></th>
                            <th class="db-table-head-th"><?php echo e(__('levels.status')); ?></th>
                            <th class="db-table-head-th"><?php echo e(__('levels.actions')); ?></th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>

</div>

<?php $__env->stopSection(); ?>



<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/lib/datatable/css/dataTables.tailwindcss.css')); ?>">
<?php $__env->stopPush(); ?>
    
<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('backend/lib/datatable/js/dataTables.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/lib/datatable/js/dataTables.tailwindcss.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/lib/datatable/js/tailwindcss.js')); ?>"></script>
    <script src="<?php echo e(asset('js/restaurant/index.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/mahbub/workspace/8.2/Foodbank/resources/views/admin/restaurant/index.blade.php ENDPATH**/ ?>