<?php $__env->startSection('template_title'); ?>
    <?php echo e(trans('installer_messages.purchase-code.templateTitle')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('title'); ?>
    <i class="fa fa-magic fa-fw" aria-hidden="true"></i>
    <?php echo trans('installer_messages.purchase-code.title'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <form method="post" action="<?php echo e(route('LaravelInstaller::purchase_code.check')); ?>" class="tabs-wrap">
        <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
        <div class="form-group <?php echo e($errors->has('purchase_code') ? ' has-error ' : ''); ?>">
            <label for="purchase_code" class="ml-3">
                <?php echo e(trans('installer_messages.purchase-code.form.purchase_code_label')); ?> <a class="" data-toggle="modal" data-target="#myModal" title="Click"> <i class="fa fa-question-circle"></i> <span class="text-danger">(<?php echo e(__(' Please click to see License activation process')); ?>)</span></a>
            </label>
            <input type="text" name="purchase_code" id="purchase_code" value="<?php echo e(old('purchase_code')); ?>" placeholder="<?php echo e(trans('installer_messages.purchase-code.form.purchase_code_label')); ?>" />
            <?php if($errors->has('purchase_code')): ?>
                <span class="error-block">
                    <i class="fa fa-fw fa-exclamation-triangle" aria-hidden="true"></i>
                    <?php echo e($errors->first('purchase_code')); ?>

                </span>
            <?php endif; ?>
        </div>

        <div class="buttons">
            <button class="button" onclick="showDatabaseSettings();return false">
                <?php echo e(trans('installer_messages.purchase-code.form.buttons.verify')); ?>

                <i class="fa fa-angle-right fa-fw" aria-hidden="true"></i>
            </button>
        </div>
    </form>

    <!-- Modal -->
    <div class="modal fade" id="myModal" role="dialog">
        <div class="modal-dialog modal-lg">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title"><?php echo e(__('Activate license code process. ')); ?></h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <section class="mb-5">
                        <h4 class="mb-2"><?php echo e(__('Step1: ')); ?> <a href="<?php echo e(config('installer.upgradeLicenseCodeUrl')); ?>" target="_blank"><?php echo e(__(' Go to iNilabs')); ?></a></h4>
                        <picture>
                            <img src="<?php echo e(asset('installer/img/home.png')); ?>" class="img-fluid img-thumbnail image-css"  alt="...">
                        </picture>
                    </section>
                    <section class="mb-5">
                        <h4 class="mb-2"><?php echo e(__('Step2: ')); ?> <a href="<?php echo e(config('installer.upgradeLicenseCodeUrl')); ?>" target="_blank"><?php echo e(__(' Login to iNilabs')); ?></a></h4>
                        <picture>
                            <img src="<?php echo e(asset('installer/img/login.png')); ?>" class="img-fluid img-thumbnail image-css"  alt="...">
                        </picture>
                    </section>
                    <section class="mb-5">
                        <h4><?php echo e(__('Step3: ')); ?> <a href="<?php echo e(config('installer.upgradeLicenseCodeUrl')); ?>" target="_blank"><?php echo e(__(' Active your license code')); ?> </a></h4>
                        <h6><?php echo e(__('You can easily get the activation code and try to install your product by this code.')); ?></h6>
                        <picture class="mt-1">
                            <img src="<?php echo e(asset('installer/img/active.png')); ?>" class="img-fluid img-thumbnail image-css"  alt="...">
                        </picture>
                    </section>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <link href="<?php echo e(asset('installer/css/bootstrap.css')); ?>" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="<?php echo e(asset('common/scripts/jquery-3.4.1.min.js')); ?>"></script>
    <link href="<?php echo e(asset('installer/css/bootstrap.bundle.min.js')); ?>" rel="stylesheet" type="text/css" />
<?php $__env->stopSection(); ?>

<?php echo $__env->make('vendor.installer.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/mahbub/workspace/8.2/Foodbank/resources/views/vendor/installer/purchase-code.blade.php ENDPATH**/ ?>