<?php $__env->startPush('style'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('frontend/lib/inttelinput/css/intlTelInput.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('main-content'); ?>
    <!--======== SETTINGS PART START =======-->
    <section class="settings">
        <div class="container">
            <div class="row">

                <?php echo $__env->make('frontend.account.partials._sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="col-12 col-lg-8 col-xl-9">
                    <div class="profile-user">
                        <div class="profile-meta">
                            <img alt="image" src="<?php echo e($user->image); ?>">
                            <dl>
                                <dt> <?php echo e($user->name); ?> </dt>
                                <dd>
                                    <span><small><?php echo e(__('levels.limit')); ?></small>
                                        <?php echo e(isset($user->deposit->limit_amount) ? currencyFormat($user->deposit->limit_amount) : ''); ?>

                                    </span>
                                    <span><small><?php echo e(__('levels.deposit')); ?></small>
                                        <?php echo e(isset($user->deposit->deposit_amount) ? currencyFormat($user->deposit->deposit_amount) : ''); ?>

                                    </span>
                                    <span><small><?php echo e(__('levels.credit')); ?> </small>
                                        <?php echo e(currencyFormat($user->balance->balance)); ?>

                                    </span>

                                    <?php if(auth()->user()->myrole == \App\Enums\UserRole::DELIVERYBOY): ?>
                                        <span><small><?php echo e(__('C.O.D. Amount')); ?> </small>
                                            <?php echo e(currencyFormat($user->deliveryBoyAccount->balance > 0 ? $user->deliveryBoyAccount->balance : 0)); ?>

                                        </span>
                                    <?php endif; ?>
                                </dd>
                            </dl>
                        </div>
                        <ul class="profile-data">
                            <li><span><?php echo e(__('levels.username')); ?> </span><?php echo e($user->username); ?> </li>
                            <li><span><?php echo e(__('levels.phone')); ?></span>+<?php echo e($user->country_code); ?> <?php echo e($user->phone); ?></li>
                            <li><span><?php echo e(__('levels.email')); ?></span><?php echo e($user->email); ?></li>
                            <li><span><?php echo e(__('levels.address')); ?></span><?php echo e($user->address); ?></li>
                        </ul>
                    </div>
                    <fieldset class="form-fieldset">
                        <legend class="form-legend"> <?php echo e(__('frontend.edit_profile')); ?></legend>
                        <form class="row" action="<?php echo e(route('account.profile.update', $user)); ?>" method="POST"
                            enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <div class="col-12 col-sm-6 form-group">
                                <label for="fname" class="form-label required"><?php echo e(__('levels.first_name')); ?> </label>
                                <input id="fname" type="text" name="first_name"
                                    class="form-control <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    value="<?php echo e(old('first_name', $user->first_name)); ?>">
                                <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-12 col-sm-6 form-group">
                                <label for="lname" class="form-label required"><?php echo e(__('levels.last_name')); ?> </label>
                                <input id="lname" type="text" name="last_name"
                                    class="form-control <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    value="<?php echo e(old('last_name', $user->last_name)); ?>">
                                <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-12 col-md-6 form-group">
                                <label for="email" class="form-label required"><?php echo e(__('levels.email')); ?> </label>
                                <input id="email" type="text" name="email"
                                    class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    value="<?php echo e(old('email', $user->email)); ?>">
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-12 col-md-6 form-group">
                                <label for="number" class="form-label required"><?php echo e(__('levels.phone')); ?> </label>
                                    <input class="form-control mobilenumber <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> phone" type="tel"
                                    id="number" name="phone" placeholder="" value="<?php echo e(old('phone', $user->phone)); ?>" onkeypress='validate(event)'>

                                <input type="hidden" id="code" name="countrycode" value="<?php echo e($user->country_code); ?>">
                                <input type="hidden" id="code_name" name="countrycodename" value="<?php echo e($user->country_code_name); ?>">

                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-12 form-group">
                                <label for="uname" class="form-label required"><?php echo e(__('levels.username')); ?></label>
                                <input id="uname" type="text" name="username"
                                    class="form-control <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    value="<?php echo e(old('username', $user->username)); ?>">
                                <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-12 form-group">
                                <label for="address" class="form-label required"><?php echo e(__('levels.address')); ?></label>
                                <textarea name="address" class="form-control " id="address"><?php echo e(old('address', $user->address)); ?></textarea>
                                <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-12 form-group isolate">
                                <label class="form-label required"><?php echo e(__('levels.image')); ?> </label>
                                <div class="form-uploader">
                                    <img id="previewImage" src="<?php echo e($user->image); ?>"  alt="<?php echo e($user->name); ?> <?php echo e(__('profile image')); ?>"/>

                                    <span><?php echo e(__('levels.upload_profile_image')); ?></span>

                                    <label for="uploader"><?php echo e(__('levels.choose_file')); ?> </label>

                                    <input name="image" type="file"
                                        class="custom-file-input <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="uploader"
                                        onchange="readURL(this);" hidden>

                                    <?php if($errors->has('image')): ?>
                                        <div class="help-block text-danger">
                                            <?php echo e($errors->first('image')); ?>

                                        </div>
                                    <?php endif; ?>

                                </div>
                            </div>
                            <div class="col-12 mt-3">
                                <button class="form-btn-inline" type="submit">
                                    <?php echo e(__('frontend.update_profile')); ?></button>
                            </div>
                        </form>
                    </fieldset>
                </div>

            </div>
        </div>
    </section>
    <!--======= SETTINGS PART END ====-->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        var country_code_name = "<?php echo e($user->country_code_name); ?>";
    </script>
    <script defer src="<?php echo e(asset('frontend/lib/inttelinput/js/intlTelInput-jquery.js')); ?>"></script>
    <script defer src="<?php echo e(asset('frontend/lib/inttelinput/js/intlTelInput.js')); ?>"></script>
    <script defer src="<?php echo e(asset('frontend/lib/inttelinput/js/utils.js')); ?>"></script>
    <script defer src="<?php echo e(asset('frontend/lib/inttelinput/js/data.js')); ?>"></script>
    <script defer src="<?php echo e(asset('frontend/lib/inttelinput/js/init.js')); ?>"></script>


    <script src="<?php echo e(asset('js/profile/index.js')); ?>"></script>
    <script src="<?php echo e(asset('js/phone_validation/index.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/mahbub/workspace/8.2/Foodbank/resources/views/frontend/account/profile.blade.php ENDPATH**/ ?>